/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;

public class ants
extends PApplet {
    int PHEROMONES_FADE_RATIO = 50;
    int PHEROMONE_SIGNAL_STRENGTH = 3;
    int simulationWidth = 600;
    int simulationHeight = 600;
    int numAntHills = 5;
    int maxAntsPerHill = 500;
    int FOOD_AMOUNT = 20;
    float ANT_SPAWN_PROBABILITY = 1.0f;
    int ANT_HILL_INITIAL_HEALTH = 10000;
    int ANT_CARRYING_FOOD_COLOR = this.color(250, 250, 250);
    int ANT_LOOK_FOR_FOOD_COLOR = this.color(0, 0, 0);
    int TERRAIN_OBSTACLE_COLOR = this.color(64, 64, 64);
    int TERRAIN_BACKGROUND_COLOR = this.color(128, 128, 64);
    int FOOD_COLOR = this.color(255, 255, 255);
    int ANT_HILL_COLOR = this.color(255, 0, 255);
    int PHEROMONES_COLOR = this.color(108, 108, 44);
    int[] pheromones;
    boolean[] food;
    boolean[] terrain;
    AntHill[] antHills;
    PImage loadScreen;
    int curSimStep = 0;
    int pheromonesLastFade = 0;
    PImage worldImg;
    boolean started = false;
    PFont font;

    public void setup() {
        this.size(this.simulationWidth, this.simulationHeight);
        this.font = this.loadFont("Cambria-18.vlw");
        this.loadScreen = this.loadImage("loadscreen.jpg");
        this.worldImg = this.createImage(this.simulationWidth, this.simulationHeight, 1);
        this.resetSimulation();
        this.noLoop();
    }

    public void draw() {
        if (!this.started) {
            this.background(0);
            this.image(this.loadScreen, 0.0f, 0.0f, this.width, this.height);
            this.fill(255);
            this.textAlign(3, 3);
            this.textFont(this.font);
            this.text("Press any key to start", (float)(this.width / 2), (float)(this.height / 2));
            return;
        }
        this.simulationStep();
        this.renderWorld(this.worldImg);
        this.image(this.worldImg, 0.0f, 0.0f);
    }

    public void keyPressed() {
        if (!this.started) {
            this.started = true;
            this.loop();
            return;
        }
        this.resetSimulation();
    }

    public void resetSimulation() {
        this.clearPheromones();
        this.setupTerrain();
        this.scatterFood();
        this.setupAnts();
    }

    public void clearPheromones() {
        this.pheromones = new int[this.simulationWidth * this.simulationHeight];
        int n = 0;
        while (n < this.pheromones.length) {
            this.pheromones[n] = 0;
            ++n;
        }
    }

    public void setupTerrain() {
        this.terrain = new boolean[this.simulationWidth * this.simulationHeight];
        int n = 0;
        while (n < this.terrain.length) {
            this.terrain[n] = false;
            ++n;
        }
    }

    public void scatterFood() {
        PGraphics pGraphics = this.createGraphics(this.simulationWidth, this.simulationHeight, "processing.core.PGraphics2D");
        pGraphics.beginDraw();
        pGraphics.background(0);
        pGraphics.ellipseMode(3);
        pGraphics.fill(255);
        pGraphics.noStroke();
        int n = 0;
        while (n < this.FOOD_AMOUNT) {
            int n2 = (int)this.random(0.0f, this.simulationWidth - 1);
            int n3 = (int)this.random(0.0f, this.simulationHeight - 1);
            int n4 = (int)this.random(5.0f, this.simulationWidth / 20);
            pGraphics.ellipse(n2, n3, n4, n4);
            ++n;
        }
        pGraphics.endDraw();
        PImage pImage = pGraphics.get(0, 0, pGraphics.width, pGraphics.height);
        pImage.loadPixels();
        this.food = new boolean[this.simulationWidth * this.simulationHeight];
        int n5 = 0;
        while (n5 < pImage.pixels.length) {
            int n6 = this.color(0, 0, 0);
            this.food[n5] = pImage.pixels[n5] != n6;
            ++n5;
        }
    }

    public void setupAnts() {
        this.curSimStep = 0;
        this.pheromonesLastFade = 0;
        this.antHills = new AntHill[this.numAntHills];
        int n = 0;
        while (n < this.numAntHills) {
            int n2;
            int n3;
            do {
                boolean bl = !this.terrain[(n3 = (int)this.random(0.0f, this.simulationWidth - 1)) + (n2 = (int)this.random(0.0f, this.simulationHeight - 1)) * this.simulationWidth] && !this.food[n3 + n2 * this.simulationWidth];
            } while (false);
            this.antHills[n] = new AntHill(n3, n2);
            ++n;
        }
    }

    public void simulationStep() {
        ++this.curSimStep;
        this.fadePheromones();
        int n = 0;
        while (n < this.numAntHills) {
            this.antHills[n].simulate();
            ++n;
        }
        if (this.random(1000.0f) < 3.0f) {
            this.addFood();
        }
    }

    public void renderWorld(PImage pImage) {
        pImage.loadPixels();
        int n = 0;
        while (n < this.terrain.length) {
            pImage.pixels[n] = this.terrain[n] ? this.TERRAIN_OBSTACLE_COLOR : this.TERRAIN_BACKGROUND_COLOR;
            ++n;
        }
        n = 0;
        while (n < this.food.length) {
            if (this.food[n]) {
                pImage.pixels[n] = this.FOOD_COLOR;
            }
            ++n;
        }
        n = 0;
        while (n < this.pheromones.length) {
            if (this.pheromones[n] > 0) {
                pImage.pixels[n] = this.PHEROMONES_COLOR;
            }
            ++n;
        }
        n = 0;
        while (n < this.antHills.length) {
            this.antHills[n].draw(pImage);
            ++n;
        }
        pImage.updatePixels();
    }

    public void fadePheromones() {
        if (this.curSimStep - this.pheromonesLastFade == this.PHEROMONES_FADE_RATIO) {
            this.pheromonesLastFade = this.curSimStep;
            int n = 0;
            while (n < this.pheromones.length) {
                this.pheromones[n] = ants.max(0, this.pheromones[n] - 1);
                ++n;
            }
        }
    }

    public void addFood() {
        PGraphics pGraphics = this.createGraphics(this.simulationWidth, this.simulationHeight, "processing.core.PGraphics2D");
        pGraphics.beginDraw();
        pGraphics.background(0);
        pGraphics.ellipseMode(3);
        pGraphics.fill(255);
        pGraphics.noStroke();
        int n = 0;
        while (n < 2) {
            int n2 = (int)this.random(0.0f, this.simulationWidth - 1);
            int n3 = (int)this.random(0.0f, this.simulationHeight - 1);
            int n4 = (int)this.random(5.0f, this.simulationWidth / 30);
            pGraphics.ellipse(n2, n3, n4, n4);
            ++n;
        }
        pGraphics.endDraw();
        PImage pImage = pGraphics.get(0, 0, pGraphics.width, pGraphics.height);
        pImage.loadPixels();
        int n5 = 0;
        while (n5 < pImage.pixels.length) {
            int n6 = this.color(0, 0, 0);
            if (pImage.pixels[n5] != n6) {
                this.food[n5] = true;
            }
            ++n5;
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--present", "--bgcolor=#666666", "--stop-color=#cccccc", "ants"});
    }

    class Ant {
        private int[] movementChoices;
        static final int pheromoneSearchRadius = 20;
        private boolean carryingFood;
        private int posX;
        private int posY;
        private int lookingAtX;
        private int lookingAtY;
        private AntHill home;
        private int state;
        private boolean wasFollowingPheromone;
        int health;

        public Ant(AntHill antHill) {
            this.home = antHill;
            this.reset();
        }

        public void simulate() {
            switch (this.state) {
                case 0: {
                    this.lookForFood();
                    break;
                }
                case 1: {
                    this.goHome();
                    break;
                }
            }
        }

        public void draw(PImage pImage) {
            int n = 0;
            n = this.state == 1 ? ants.this.ANT_CARRYING_FOOD_COLOR : ants.this.ANT_LOOK_FOR_FOOD_COLOR;
            pImage.pixels[this.posX + this.posY * ants.this.simulationWidth] = n;
        }

        public void reset() {
            this.posX = this.home.posX;
            this.posY = this.home.posY;
            this.state = 0;
            this.wasFollowingPheromone = false;
            this.lookingAtX = 0;
            this.lookingAtY = 0;
            this.health = this.home.antHillHealth;
            this.movementChoices = new int[861];
        }

        public boolean isAlive() {
            return this.health > 0;
        }

        private void lookForFood() {
            this.move();
            if (ants.this.food[this.posX + this.posY * ants.this.simulationWidth]) {
                this.consumeFood();
            } else {
                --this.health;
            }
        }

        private void consumeFood() {
            ants.this.food[this.posX + this.posY * ants.this.simulationWidth] = false;
            this.state = 1;
            ++this.home.antHillHealth;
            this.health = this.home.antHillHealth;
        }

        private void move() {
            int n;
            int n2;
            int n3 = 20;
            int n4 = -this.lookingAtY;
            int n5 = this.lookingAtX;
            int n6 = this.lookingAtX;
            int n7 = this.lookingAtY;
            int n8 = 0;
            int n9 = 0;
            while (n9 <= n3) {
                int n10 = -n3;
                while (n10 <= n3) {
                    if (n10 != 0 || n9 != 0) {
                        int n11 = n4 * n10 + n5 * n9;
                        int n12 = n6 * n10 + n7 * n9;
                        if (this.foodAt(n11, n12)) {
                            this.applyMove(ants.constrain(n11, -1, 1), ants.constrain(n12, -1, 1));
                            if (ants.abs(n11) <= 1 && ants.abs(n12) <= 1) {
                                this.consumeFood();
                            }
                            return;
                        }
                        if (this.pheromonesAt(n11, n12)) {
                            this.wasFollowingPheromone = true;
                            n2 = n11 > 0 ? 1 : -1;
                            n = n12 > 0 ? 1 : -1;
                            this.movementChoices[n8] = this.encodeOffsets(n2, n);
                            ++n8;
                        }
                    }
                    ++n10;
                }
                ++n9;
            }
            n2 = 0;
            n = 0;
            if (n8 > 0) {
                n9 = (int)ants.this.random(n8 - 1);
                int[] nArray = new int[2];
                this.decodeOffsets(this.movementChoices[n9], nArray);
                n2 = nArray[0];
                n = nArray[1];
            }
            if (this.wasFollowingPheromone && n2 == 0 && n == 0) {
                n2 = this.lookingAtX;
                n = this.lookingAtY;
                this.wasFollowingPheromone = false;
            }
            if (n2 == 0 && n == 0) {
                this.wasFollowingPheromone = false;
                n2 = ants.this.random(1.0f) < 0.5f ? 1 : -1;
                n = ants.this.random(1.0f) < 0.5f ? 1 : -1;
            }
            this.applyMove(n2, n);
        }

        public void applyMove(int n, int n2) {
            if (n != 0 || n2 != 0) {
                this.lookingAtX = n;
                this.lookingAtY = n2;
            } else {
                this.lookingAtX = 1;
                this.lookingAtY = 1;
            }
            this.posX = ants.constrain(this.posX + n, 0, ants.this.simulationWidth - 1);
            this.posY = ants.constrain(this.posY + n2, 0, ants.this.simulationHeight - 1);
            if (ants.this.pheromones[this.posX + this.posY * ants.this.simulationWidth] > 0) {
                int n3 = this.posX + this.posY * ants.this.simulationWidth;
                ants.this.pheromones[n3] = ants.this.pheromones[n3] - 1;
            }
        }

        private void goHome() {
            if (this.posX == this.home.posX && this.posY == this.home.posY) {
                this.carryingFood = false;
                this.state = 0;
            } else {
                if (ants.abs(this.home.posX - this.posX) >= ants.abs(this.home.posY - this.posY)) {
                    if (this.home.posX < this.posX) {
                        if (this.posX > 0 && !ants.this.terrain[this.posX - 1 + this.posY * ants.this.simulationWidth]) {
                            --this.posX;
                        }
                    } else if (this.home.posX > this.posX && this.posX < ants.this.simulationWidth - 1 && !ants.this.terrain[this.posX + 1 + this.posY * ants.this.simulationWidth]) {
                        ++this.posX;
                    }
                } else if (this.home.posY < this.posY) {
                    if (this.posY > 0 && !ants.this.terrain[this.posX + (this.posY - 1) * ants.this.simulationWidth]) {
                        --this.posY;
                    }
                } else if (this.home.posY > this.posY && this.posY < ants.this.simulationHeight - 1 && !ants.this.terrain[this.posX + (this.posY + 1) * ants.this.simulationWidth]) {
                    ++this.posY;
                }
                if (ants.this.pheromones[this.posX + this.posY * ants.this.simulationWidth] < 100) {
                    int n = this.posX + this.posY * ants.this.simulationWidth;
                    ants.this.pheromones[n] = ants.this.pheromones[n] + ants.this.PHEROMONE_SIGNAL_STRENGTH;
                }
            }
        }

        private boolean pheromonesAt(int n, int n2) {
            if (this.posX + n < 0) {
                return false;
            }
            if (this.posX + n > ants.this.simulationWidth - 1) {
                return false;
            }
            if (this.posY + n2 < 0) {
                return false;
            }
            if (this.posY + n2 > ants.this.simulationHeight - 1) {
                return false;
            }
            return ants.this.pheromones[this.posX + n + (this.posY + n2) * ants.this.simulationWidth] > 0;
        }

        private boolean foodAt(int n, int n2) {
            if (this.posX + n < 0) {
                return false;
            }
            if (this.posX + n > ants.this.simulationWidth - 1) {
                return false;
            }
            if (this.posY + n2 < 0) {
                return false;
            }
            if (this.posY + n2 > ants.this.simulationHeight - 1) {
                return false;
            }
            return ants.this.food[this.posX + n + (this.posY + n2) * ants.this.simulationWidth];
        }

        private void decodeOffsets(int n, int[] nArray) {
            nArray[0] = ((n & 0xC) >> 2) - 1;
            nArray[1] = (n & 3) - 1;
        }

        private int encodeOffsets(int n, int n2) {
            int n3 = (n + 1 & 3) << 2 | n2 + 1 & 3;
            return n3;
        }
    }

    class AntHill {
        public int posX;
        public int posY;
        private int numAnts;
        private Ant[] ants;
        public int antHillHealth;

        public AntHill(int n, int n2) {
            this.posX = n;
            this.posY = n2;
            this.ants = new Ant[ants.this.maxAntsPerHill];
            this.numAnts = 0;
            this.antHillHealth = ants.this.ANT_HILL_INITIAL_HEALTH;
        }

        public void simulate() {
            if (this.antHillHealth > 0 && this.numAnts < ants.this.maxAntsPerHill && ants.this.random(1.0f) < ants.this.ANT_SPAWN_PROBABILITY) {
                this.spawnAnt();
            }
            int n = 0;
            while (n < this.numAnts) {
                if (this.ants[n].isAlive()) {
                    this.ants[n].simulate();
                }
                ++n;
            }
        }

        public void draw(PImage pImage) {
            pImage.pixels[this.posX + this.posY * ants.this.simulationWidth] = ants.this.ANT_HILL_COLOR;
            int n = 0;
            while (n < this.numAnts) {
                if (this.ants[n].isAlive()) {
                    this.ants[n].draw(pImage);
                }
                ++n;
            }
        }

        private void spawnAnt() {
            --this.antHillHealth;
            int n = 0;
            while (n < this.numAnts) {
                if (!this.ants[n].isAlive()) {
                    this.ants[n].reset();
                    return;
                }
                ++n;
            }
            this.ants[this.numAnts] = new Ant(this);
            ++this.numAnts;
        }
    }
}

